/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.shared.platform.InvalidateCallback;
import net.minecraft.core.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jspecify.annotations.Nullable;

public final class CapabilityUtil {
    private CapabilityUtil() {
    }

    public static <T> @Nullable LazyOptional<T> invalidate(@Nullable LazyOptional<T> cap) {
        if (cap != null) {
            cap.invalidate();
        }
        return null;
    }

    public static <T> void invalidate(@Nullable LazyOptional<T> @Nullable [] caps) {
        if (caps == null) {
            return;
        }
        for (int i = 0; i < caps.length; ++i) {
            LazyOptional<T> cap = caps[i];
            if (cap != null) {
                cap.invalidate();
            }
            caps[i] = null;
        }
    }

    public static <T> @Nullable T unwrap(LazyOptional<T> p, InvalidateCallback invalidate) {
        if (!p.isPresent()) {
            return null;
        }
        p.addListener(invalidate.castConsumer());
        return (T)p.orElseThrow(NullPointerException::new);
    }

    public static <T> LazyOptional<T> getCapability(ICapabilityProvider provider, Capability<T> capability, @Nullable Direction side) {
        LazyOptional cap = provider.getCapability(capability);
        return !cap.isPresent() && side != null ? provider.getCapability(capability, side) : cap;
    }
}

